/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import xyz.przemyk.simpleplanes.EnergyStorageWithSet;
import xyz.przemyk.simpleplanes.setup.SimplePlanesBlocks;

public class ChargingStationTile
extends BlockEntity {
    public final EnergyStorageWithSet energyStorage = new EnergyStorageWithSet(1000);
    public final LazyOptional<EnergyStorage> energyStorageLazyOptional = LazyOptional.of(() -> this.energyStorage);

    public ChargingStationTile(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)SimplePlanesBlocks.CHARGING_STATION_TILE.get(), blockPos, blockState);
    }

    public static void tick(ChargingStationTile blockEntity) {
        for (Entity entity : blockEntity.f_58857_.m_45933_(null, new AABB(blockEntity.f_58858_.m_7494_()))) {
            entity.getCapability(CapabilityEnergy.ENERGY, Direction.DOWN).ifPresent(entityEnergy -> blockEntity.energyStorage.extractEnergy(entityEnergy.receiveEnergy(blockEntity.energyStorage.extractEnergy(1000, true), false), false));
        }
    }

    protected void m_183515_(CompoundTag compoundTag) {
        compoundTag.m_128405_("energy", this.energyStorage.getEnergyStored());
    }

    public void m_142466_(CompoundTag compoundTag) {
        this.energyStorage.setEnergy(compoundTag.m_128451_("energy"));
        super.m_142466_(compoundTag);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyStorageLazyOptional.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyStorageLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }
}

